require("dotenv").config();
const express = require('express');
const app = express();
var cors = require('cors');

const userRouter = require("./api/users/user.router");
const miscRouter = require("./api/misc/misc.router");
const deviceRouter = require("./api/device/device.router");
const customerRouter = require("./api/customer/customers.router");
const transactionRouter = require("./api/transactions/transaction.router");

app.use(express.json());

app.use(cors());
app.use("/api/misc", miscRouter);
app.use("/api/users", userRouter);
app.use("/api/device", deviceRouter);
app.use("/api/customer", customerRouter);
app.use("/api/transaction", transactionRouter);

app.listen(process.env.APP_PORT, () => {
    console.log("Server up and running on PORT: ", process.env.APP_PORT);
})