const pool = require("../../config/database");

module.exports = {
  // Check User
  checkUser: async (data) => {
    try {
      const [results] = await pool.query(
        `SELECT UserID as userID, UserName as username, MobilePassword, Device_id as deviceID, device_status as status, bank_code as bankCode FROM systemusers WHERE UserName=?`,
        [data.username]
      );

      if (results.length === 0) {
        return null;
      }

      return results[0];
    } catch (error) {
      throw error;
    }
  },

  // Get Users
  getUsers: async () => {
    try {
      const [results] = await pool.query(
        `SELECT UserName as username, Device_id as deviceID, device_status as status, bank_code as bankCode FROM systemusers`
      );
      return results;
    } catch (error) {
      throw error;
    }
  },
};
