const { getUsers, checkUser } = require("./user.service");
const { hashSync, genSaltSync, compareSync } = require("bcrypt");
const { sign, verify } = require("jsonwebtoken");

module.exports = {
  // User login
  login: async (req, res) => {
    const body = req.body;

    if (!body.username || !body.password) {
      return res.status(401).json({
        success: 0,
        message: "Username or password is missing",
      });
    }

    try {
      const results = await checkUser(body);

      if (!results) {
        return res.status(401).json({
          success: 0,
          message: "Invalid Username",
        });
      }

      // Use compareSync for password comparison
      // const result = body.password === results.MobilePassword;
      const result = compareSync(body.password, results.MobilePassword);

      if (result) {
        results.MobilePassword = undefined;
        const jsonToken = sign({ result: results }, process.env.JWT_KEY, {
          expiresIn: "3h",
        });
        return res.status(200).json({
          success: 1,
          message: "Login successfully",
          results: results,
          token: jsonToken,
        });
      } else {
        return res.status(401).json({
          success: 0,
          message: "Invalid username or password",
        });
      }
    } catch (err) {
      console.log(err);
      return res.status(500).json({
        success: 0,
        message: "Internal server error, try again later.",
        error: err,
      });
    }
  },

  // Get Users
  getUsers: async (req, res) => {
    try {
      const results = await getUsers();
      return res.status(200).json({
        success: true,
        count: results.length,
        data: results,
      });
    } catch (err) {
      console.log(err);
      return res.status(500).json({
        success: false,
        message: "Internal server error, try again later.",
        error: err,
      });
    }
  },
};
