const e = require("cors");
const pool = require("../../config/database");

module.exports = {
  //Get Saving Accounts
  getSavingAccounts: async () => {
    try {
      const [results] = await pool.query(`CALL API_WP_GET_ACCOUNTS_LIST`, []);
      return results;
    } catch (error) {
      throw error;
    }
  },
  //Get Loan Accounts
  getLoanAccounts: async () => {
    try {
      const [results] = await pool.query(
        `CALL API_WP_GET_LOAN_ACCOUNTS_LIST`,
        []
      );
      return results;
    } catch (error) {
      throw error;
    }
  },

  // Add Transaction
  addTransaction: async (data) => {
    let connection;
    try {
      connection = await pool.getConnection();
      await connection.beginTransaction();

      const [results] = await connection.query(
        `CALL API_WP_ADD_TRANSACTION_LOAN(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)`,
        [
          data.Id,
          data.AccNo,
          data.usID,
          data.TraDate,
          data.TraTime,
          data.Debit,
          data.Credit,
          data.UserID,
          data.DeviceID,
          data.Latitude,
          data.Longitude,
          new Date(),
        ]
      );

      await connection.commit();
      return results;
    } catch (error) {
      if (connection) {
        await connection.rollback();
      }
      throw error;
    } finally {
      if (connection) {
        connection.release();
      }
    }
  },

  addRealTimeSaving: async (data) => {
    let connection;
    try {
      connection = await pool.getConnection();
      await connection.beginTransaction();

      // NOTE: Variables
      const [yearPart, monthPart] = [
        new Date().getFullYear().toString().slice(-2),
        (new Date().getMonth() + 1).toString().padStart(2, "0"),
      ];
      const TransactionType = "R";
      let newTransactionNumber; // Done
      let fo_cashbook_id; // Done
      const cleanAmount = parseFloat(data.Debit.replace(/,/g, "").trim());
      let AccountBalance; // Done
      let LedgerID; // Done
      let PassBookType;
      let PASS_CARD_PAGE_RENEW_MAX_NUMBER;
      let PASS_BOOK_PAGE_GUTTER_START_NUMBER;
      let PASS_BOOK_PAGE_GUTTER_END_NUMBER;
      let PASS_BOOK_PAGE_RENEW_MAX_NUMBER;
      let NewPrintTraNo;
      let NewPageNo;
      let SMSendForAllCustomersByBankRule;
      let PrintReceiptForEveryCustomer;
      let sms;

      // Add API_WP_ADD_TRANSACTION
      await connection.query(
        `CALL API_WP_ADD_TRANSACTION(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)`,
        [
          data.Id,
          data.AccNo,
          data.usID,
          data.TraDate,
          data.TraTime,
          data.Debit,
          data.Credit,
          data.Username ?? '',
          data.UserID,
          data.DeviceID,
          data.Latitude,
          data.Longitude,
          new Date(),
        ]
      );

      // NOTE: Get the last receipt number
      const [results1] = await connection.query(
        `SELECT MAX(RIGHT(last_ReceiptNo, 5)) AS maxReceiptNo FROM systemusers WHERE MID(last_ReceiptNo, 4, 4) = ? AND MID(last_ReceiptNo, 8, 2) = ?`,
        [yearPart + monthPart, data.UserID]
      );

      // COMMENT: Generate new transaction number
      if (results1 !== null) {
        const nextNumber = (parseInt([results1[0].maxReceiptNo], 10) + 1)
          .toString()
          .padStart(5, "0");
        newTransactionNumber = `${TransactionType}${data.BankCode}${yearPart}${monthPart}${data.UserID}${nextNumber}`;
      } else {
        newTransactionNumber = `${TransactionType}${data.BankCode}${yearPart}${monthPart}${data.UserID}00001`;
      }

      // NOTE:
      const [results2] = await connection.query(
        `SELECT sCustomerAddress AS Address, sCustomerFullName, CustomerName, CustomerAddress FROM customerinformation WHERE CustomerID = ?`,
        [data.CusID]
      );

      // COMMENT: Destructure customer information
      const {
        Address: sCusAddress,
        sCustomerFullName: sCusName,
        CustomerName: eCusName,
        CustomerAddress: eCusAddress,
      } = results2[0];

      // NOTE: Get Cashbook ID
      const [results3] = await connection.query(
        `SELECT fo_cashbook_id FROM systemusers WHERE UserID=?`,
        [data.UserID]
      );
      // COMMENT: Assign the cashbook ID
      fo_cashbook_id = results3[0]["fo_cashbook_id"];

      if (cleanAmount > 0) {
        const [results4] = await connection.query(
          `INSERT INTO ledgertransactions 
        (TransactionID, LedgerID, AccountNumber, CustomerID, CustomerName, CustomerAddress, TransactionDate, TransactionTime, 
        DebitAmount, CreditAmount, AccountBalance, ChequeNo, ChequeDate, Description, TransactionType, TransactionLog, 
        TransactionNo, PageNo, UserID, sDescription, sCustomerName, sCustomerAddress, CashTenderd, CashBalance, prntDescription, 
        CashOrBankLedgerID, CashOrCurrentAccount, TransactionRelatedBranch)
        VALUES 
        (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)`,
          [
            newTransactionNumber,
            fo_cashbook_id,
            null,
            data.CusID,
            eCusName,
            eCusAddress,
            new Date().toISOString().split("T")[0],
            new Date().toLocaleTimeString("en-US", {
              hour: "2-digit",
              minute: "2-digit",
              second: "2-digit",
              hour12: true,
            }),
            cleanAmount,
            "0.00",
            null,
            null,
            null,
            `MOBILE CASH DEPOSIT ${data.AccNo} AMOUNT. ${data.Debit} REF. ${data.MobileNote}`,
            "R",
            "Receipt Batch",
            null,
            null,
            data.UserID,
            `idudcsl wxl ${data.CusID} f.ka uqo,a ,eîï`,
            sCusName,
            sCusAddress,
            parseFloat(data.Debit.replace(/,/g, "").trim()).toFixed(2),
            parseFloat(data.Debit.replace(/,/g, "").trim()).toFixed(2),
            `MOBILE CASH DR. A/C: ${data.AccNo} REF: ${data.MobileNote}`,
            null,
            "-",
            data.BankCode,
          ]
        );
      }

      // NOTE: Case "Saving" logic
      const [results5] = await connection.query(
        `SELECT AccountBalance, LedgerID FROM ledgerdetails WHERE AccountNumber = ?`,
        [data.AccNo]
      );
      // COMMENT: Destructure the account balance and ledger ID
      const { AccountBalance: balance, LedgerID: ledgerID } = results5[0];
      AccountBalance = balance;
      LedgerID = ledgerID;

      // NOTE: Passbook
      const [results6] = await connection.query(
        `SELECT PassBookType FROM ledgerdetails WHERE AccountNumber = ?`,
        [data.AccNo]
      );
      PassBookType = results6[0].PassBookType; // COMMENT: Destructure the passbook type

      // NOTE: Page Details
      const [results7] = await connection.query(
        `SELECT PASS_CARD_PAGE_RENEW_MAX_NUMBER, PASS_BOOK_PAGE_GUTTER_START_NUMBER, PASS_BOOK_PAGE_GUTTER_END_NUMBER, PASS_BOOK_PAGE_RENEW_MAX_NUMBER FROM applicationsettings WHERE id = '1'`,
        []
      );
      // COMMENT: Destructure page details
      PASS_CARD_PAGE_RENEW_MAX_NUMBER =
        results7[0].PASS_CARD_PAGE_RENEW_MAX_NUMBER;
      PASS_BOOK_PAGE_GUTTER_START_NUMBER =
        results7[0].PASS_BOOK_PAGE_GUTTER_START_NUMBER;
      PASS_BOOK_PAGE_GUTTER_END_NUMBER =
        results7[0].PASS_BOOK_PAGE_GUTTER_END_NUMBER;
      PASS_BOOK_PAGE_RENEW_MAX_NUMBER =
        results7[0].PASS_BOOK_PAGE_RENEW_MAX_NUMBER;

      // NOTE: Get Print Details
      const [results8] = await connection.query(
        `SELECT PrintedRecordNo, PageNo FROM ledgerdetails WHERE AccountNumber = ?`,
        [data.AccNo]
      );
      // COMMENT: Destructure print details
      const { PrintedRecordNo, PageNo } = results8[0];
      if (PrintedRecordNo != null && PageNo != null) {
        NewPrintTraNo = "1";
        NewPageNo = (PageNo + 1).toString();
      } else {
        NewPrintTraNo = (currentPrintTraNo + 1).toString();
        NewPageNo = PageNo.toString();
      }

      // NOTE: Credit Entry - Savings
      await connection.query(
        `INSERT INTO ledgertransactions (TransactionID, LedgerID, AccountNumber, CustomerID, CustomerName, CustomerAddress, TransactionDate, TransactionTime, DebitAmount, CreditAmount, AccountBalance, ChequeNo, ChequeDate, Description, TransactionType, TransactionLog, TransactionNo, PageNo, UserID, sDescription, sCustomerName, sCustomerAddress, CashTenderd, CashBalance, prntDescription, CashOrBankLedgerID, CashOrCurrentAccount, TransactionRelatedBranch) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)`,
        [
          newTransactionNumber,
          LedgerID,
          data.AccNo,
          data.CusID,
          eCusName,
          eCusAddress,
          new Date().toISOString().split("T")[0],
          new Date().toLocaleTimeString("en-US", {
            hour: "2-digit",
            minute: "2-digit",
            second: "2-digit",
            hour12: true,
          }),
          "0.00",
          cleanAmount,
          (parseFloat(AccountBalance) + parseFloat(cleanAmount)).toFixed(2),
          null,
          null,
          `MOBILE CASH DEPOSIT ${data.AccNo} AMOUNT. ${data.Debit} REF. ${data.MobileNote}`,
          "R",
          "Receipt Batch",
          NewPrintTraNo,
          NewPageNo,
          data.UserID,
          `fCIa;% uqo,a ,eîï  ${data.CusID}`,
          sCusName,
          sCusAddress,
          parseFloat(data.Debit.replace(/,/g, "").trim()).toFixed(2),
          parseFloat(data.Debit.replace(/,/g, "").trim()).toFixed(2),
          `${data.AccNo} MOBILE CR. REF: ${data.MobileNote}`,
          fo_cashbook_id,
          "CA",
          data.BankCode,
        ]
      );

      // NOTE: Update saving balance
      await connection.query(
        `UPDATE ledgerdetails SET AccountBalance = AccountBalance + ?, AccountLastTransactionDate = ? WHERE AccountNumber = ?`,
        [cleanAmount, new Date().toISOString().split("T")[0], data.AccNo]
      );

      // NOTE: Update last_ReceiptNo to `system users` table
      await connection.query(
        `UPDATE systemusers SET last_ReceiptNo = ? WHERE UserID = ?`,
        [newTransactionNumber, data.UserID]
      );

      // NOTE: SMS and Print Receipt
      const [results9] = await connection.query(
        `select SendSMSForEveryCustomer,PrintReceiptForEveryCustomer from instituteinformation where InstituteID=?`,
        [data.BankCode]
      );
      // COMMENT: Destructure SMS and Print Receipt RULES
      if (results9.length > 0) {
        const {
          SendSMSForEveryCustomer: sendSMS,
          PrintReceiptForEveryCustomer: printReceipt,
        } = results9[0];
        SMSendForAllCustomersByBankRule = sendSMS.toString();
        PrintReceiptForEveryCustomer = printReceipt.toString();
      }

      // NOTE: Generate SMS's
      const [results10] = await connection.query(
        `SELECT smsLang,PersonnalMobileNo,smsRegistered FROM customerinformation WHERE CustomerID=?`,
        [data.CusID]
      );
      // COMMENT: Destructure SMS details
      const {
        smsLang: lang,
        PersonnalMobileNo: mobileNo,
        smsRegistered: registered,
      } = results10[0];

      // COMMENT: Generate SMS
      if (
        Boolean(registered) ||
        parseInt(SMSendForAllCustomersByBankRule, 10) === 1
      ) {
        if (lang.toLowerCase() === "en") {
          sms = `Dear customer, Cash Deposit CR was performed on your account no. ${
            data.AccNo
          } for Rs. ${parseFloat(cleanAmount).toLocaleString("en-IN", {
            minimumFractionDigits: 2,
          })} Available Rs. ${(
            parseFloat(AccountBalance) + parseFloat(cleanAmount)
          ).toLocaleString("en-IN", {
            minimumFractionDigits: 2,
          })} - ${new Date().toISOString().replace("T", " ").slice(0, 19)}`;
        } else if (lang.toLowerCase() === "si") {
          sms = `Hithawath paribogikaya, Obage ${
            data.AccNo
          } ginumata Rs. ${parseFloat(cleanAmount).toLocaleString("en-IN", {
            minimumFractionDigits: 2,
          })} thampath kala. ginume sheshaya Rs. ${(
            parseFloat(AccountBalance) + parseFloat(cleanAmount)
          ).toLocaleString("en-IN", {
            minimumFractionDigits: 2,
          })} - ${new Date().toISOString().replace("T", " ").slice(0, 19)}`;
        }
        // COMMENT: Insert SMS

        await connection.query(`CALL APP_INSERT_SMS_Q(?, ?, ?, ?)`, [
          data.CusID,
          mobileNo,
          new Date().toISOString().replace("T", " ").substring(0, 19),
          sms,
        ]);
      }

      // NOTE: Comment the transaction
      await connection.commit();
      return {
        id: data.Id,
        transactionNo: newTransactionNumber,
        printReceipt: PrintReceiptForEveryCustomer,
      };
    } catch (error) {
      if (connection) {
        await connection.rollback();
      }
      throw error;
    } finally {
      if (connection) {
        connection.release();
      }
    }
  },

  // Add Real Time Loan
  addRealTimeLoan: async (data) => {
    let connection;
    try {
      connection = await pool.getConnection();
      await connection.beginTransaction();

      // NOTE: Variables
      const [yearPart, monthPart] = [
        new Date().getFullYear().toString().slice(-2),
        (new Date().getMonth() + 1).toString().padStart(2, "0"),
      ];
      const TransactionType = "R";
      let newTransactionNumber; // Done
      let fo_cashbook_id; // Done
      const cleanAmount = parseFloat(data.Debit.replace(/,/g, "").trim());
      let PASS_CARD_PAGE_RENEW_MAX_NUMBER;
      let PASS_BOOK_PAGE_GUTTER_START_NUMBER;
      let PASS_BOOK_PAGE_GUTTER_END_NUMBER;
      let PASS_BOOK_PAGE_RENEW_MAX_NUMBER;
      let NewPrintTraNo;
      let NewPageNo;
      let UserPayAmount = cleanAmount;
      let LoanInterestReceived = 0;
      let NewDueInteCF = 0;
      let LoanCapitalPortion = 0;
      let SMSendForAllCustomersByBankRule;
      let PrintReceiptForEveryCustomer;
      let sms;
      let PastDueAmountBeforeRecovery;

      // Add API_WP_ADD_TRANSACTION_LOAN
      await connection.query(
        `CALL API_WP_ADD_TRANSACTION_LOAN(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)`,
        [
          data.Id,
          data.AccNo,
          data.usID,
          data.TraDate,
          data.TraTime,
          data.Debit,
          data.Credit,
          data.UserID,
          data.DeviceID,
          data.Latitude,
          data.Longitude,
          new Date(),
        ]
      );

      // NOTE: Get the last receipt number
      const [results1] = await connection.query(
        `SELECT MAX(RIGHT(last_ReceiptNo, 5)) AS maxReceiptNo FROM systemusers WHERE MID(last_ReceiptNo, 4, 4) = ? AND MID(last_ReceiptNo, 8, 2) = ?`,
        [yearPart + monthPart, data.UserID]
      );

      // COMMENT: Generate new transaction number
      if (results1 !== null) {
        const nextNumber = (parseInt([results1[0].maxReceiptNo], 10) + 1)
          .toString()
          .padStart(5, "0");
        newTransactionNumber = `${TransactionType}${data.BankCode}${yearPart}${monthPart}${data.UserID}${nextNumber}`;
      } else {
        newTransactionNumber = `${TransactionType}${data.BankCode}${yearPart}${monthPart}${data.UserID}00001`;
      }

      // NOTE:
      const [results2] = await connection.query(
        `SELECT sCustomerAddress AS Address, sCustomerFullName, CustomerName, CustomerAddress FROM customerinformation WHERE CustomerID = ?`,
        [data.CusID]
      );

      // COMMENT: Destructure customer information
      const {
        Address: sCusAddress,
        sCustomerFullName: sCusName,
        CustomerName: eCusName,
        CustomerAddress: eCusAddress,
      } = results2[0];

      // NOTE: Get Cashbook ID
      const [results3] = await connection.query(
        `SELECT fo_cashbook_id FROM systemusers WHERE UserID=?`,
        [data.UserID]
      );
      // COMMENT: Assign the cashbook ID
      fo_cashbook_id = results3[0]["fo_cashbook_id"];
      if (cleanAmount > 0) {
        await connection.query(
          `INSERT INTO ledgertransactions 
        (TransactionID, LedgerID, AccountNumber, CustomerID, CustomerName, CustomerAddress, TransactionDate, TransactionTime, 
        DebitAmount, CreditAmount, AccountBalance, ChequeNo, ChequeDate, Description, TransactionType, TransactionLog, 
        TransactionNo, PageNo, UserID, sDescription, sCustomerName, sCustomerAddress, CashTenderd, CashBalance, prntDescription, 
        CashOrBankLedgerID, CashOrCurrentAccount, TransactionRelatedBranch)
        VALUES 
        (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)`,
          [
            newTransactionNumber,
            fo_cashbook_id,
            null,
            data.CusID,
            eCusName,
            eCusAddress,
            new Date().toISOString().split("T")[0],
            new Date().toLocaleTimeString("en-US", {
              hour: "2-digit",
              minute: "2-digit",
              second: "2-digit",
              hour12: true,
            }),
            cleanAmount,
            "0.00",
            null,
            null,
            null,
            `MOBILE LOAN RECOVERY FROM ${data.CusID} AMOUNT. ${cleanAmount}`,
            "R",
            "LOAN BATCH DEPOSIT",
            null,
            null,
            data.UserID,
            `fCIa;% Kh whùï ${data.AccNo}`,
            sCusName,
            sCusAddress,
            parseFloat(data.Debit.replace(/,/g, "").trim()).toFixed(2),
            parseFloat(data.Debit.replace(/,/g, "").trim()).toFixed(2),
            `MOB LOAN REC. DR **${parseFloat(cleanAmount).toFixed(2)} REF: ${
              data.MobileNote
            }`,
            null,
            "-",
            data.BankCode,
          ]
        );
      }

      // NOTE: Ledger Details
      const [results4] = await connection.query(
        `SELECT LedgerID, AccountBalance, PenaltyOrReservationAccount, InterestAccount, FundAccount, LoanInstallment, AccountBalanceWithInterest, PenaltyInterestAmount, InterestAmount + DueInterestAmount AS InterestAmount, FundAmount, PassBookType 
         FROM ledgerdetails 
         WHERE AccountNumber = ?`,
        [data.AccNo]
      );

      // COMMENT: Variables
      const {
        LedgerID,
        AccountBalance,
        PenaltyOrReservationAccount,
        InterestAccount,
        FundAccount,
        LoanInstallment,
        AccountBalanceWithInterest,
        PenaltyInterestAmount,
        InterestAmount,
        FundAmount,
        PassBookType,
      } = results4[0];

      // NOTE: Page Details
      const [results5] = await connection.query(
        `SELECT PASS_CARD_PAGE_RENEW_MAX_NUMBER, PASS_BOOK_PAGE_GUTTER_START_NUMBER, PASS_BOOK_PAGE_GUTTER_END_NUMBER, PASS_BOOK_PAGE_RENEW_MAX_NUMBER FROM applicationsettings WHERE id = '1'`,
        []
      );
      // COMMENT: Destructure page details
      PASS_CARD_PAGE_RENEW_MAX_NUMBER =
        results5[0].PASS_CARD_PAGE_RENEW_MAX_NUMBER;
      PASS_BOOK_PAGE_GUTTER_START_NUMBER =
        results5[0].PASS_BOOK_PAGE_GUTTER_START_NUMBER;
      PASS_BOOK_PAGE_GUTTER_END_NUMBER =
        results5[0].PASS_BOOK_PAGE_GUTTER_END_NUMBER;
      PASS_BOOK_PAGE_RENEW_MAX_NUMBER =
        results5[0].PASS_BOOK_PAGE_RENEW_MAX_NUMBER;

      // NOTE: Get Print Details
      const [results6] = await connection.query(
        `SELECT PrintedRecordNo, PageNo FROM ledgerdetails WHERE AccountNumber = ?`,
        [data.AccNo]
      );
      // COMMENT: Destructure print details
      const { PrintedRecordNo, PageNo } = results6[0];
      if (PrintedRecordNo != null && PageNo != null) {
        NewPrintTraNo = "1";
        NewPageNo = (PageNo + 1).toString();
      } else {
        NewPrintTraNo = (currentPrintTraNo + 1).toString();
        NewPageNo = PageNo.toString();
      }

      // NOTE: Variables
      let fundAmount = parseFloat(FundAmount);
      let penaltyInterestAmount = parseFloat(PenaltyInterestAmount);
      let interestAmount = parseFloat(InterestAmount);

      if (UserPayAmount < fundAmount + penaltyInterestAmount + interestAmount) {
        LoanInterestReceived =
          UserPayAmount - (fundAmount + penaltyInterestAmount);
        NewDueInteCF = interestAmount - LoanInterestReceived;
        LoanCapitalPortion = 0;
      } else if (
        UserPayAmount ===
        fundAmount + penaltyInterestAmount + interestAmount
      ) {
        LoanInterestReceived = interestAmount;
        NewDueInteCF = 0;
        LoanCapitalPortion = 0;
      } else if (
        UserPayAmount >
        fundAmount + penaltyInterestAmount + interestAmount
      ) {
        LoanInterestReceived = interestAmount;
        NewDueInteCF = 0;
        LoanCapitalPortion =
          UserPayAmount - (fundAmount + penaltyInterestAmount + interestAmount);
      }

      // NOTE: Update Ledger Details
      await connection.query(
        `UPDATE ledgerdetails SET AccountBalance = ?, AccountLastTransactionDate = ?, PrintedRecordNo = ?, PageNo = ?, InterestAmount = ?, PenaltyInterestAmount = ?, FundAmount = ?, DueInterestAmount = ?, AccountBalanceWithInterest = ? WHERE AccountNumber = ?`,
        [
          parseFloat(AccountBalance) - LoanCapitalPortion,
          new Date().toISOString().split("T")[0],
          NewPrintTraNo,
          NewPageNo,
          "0.00",
          "0.00",
          "0.00",
          NewDueInteCF.toFixed(2),
          "0.00",
          data.AccNo,
        ]
      );

      // NOTE: Insert ledger transactions
      await connection.query(
        `INSERT INTO ledgertransactions(TransactionID, LedgerID, AccountNumber, CustomerID, CustomerName, CustomerAddress, TransactionDate, DebitAmount, CreditAmount, AccountBalance, ChequeNo, ChequeDate, Description, TransactionType, TransactionLog, TransactionNo, PageNo, UserID, sDescription, sCustomerName, sCustomerAddress, InterestAmount, PenaltyInterestAmount, FundAmount, TransactionValidate, DueInterestAmount, CashTenderd, CashBalance, TransactionTime, prntDescription, TransactionRelatedBranch, AccountBalanceWithInterest) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)`,
        [
          newTransactionNumber,
          null,
          data.AccNo,
          data.CusID,
          eCusName,
          eCusAddress,
          new Date().toISOString().split("T")[0],
          "0.00",
          LoanCapitalPortion,
          parseFloat(AccountBalance) - LoanCapitalPortion,
          null,
          null,
          `Loan recovery for AC: ${data.AccNo} From ${data.CusID} Ref: ${data.MobileNote}`,
          TransactionType,
          "LOAN BATCH DEPOSIT",
          NewPrintTraNo,
          NewPageNo,
          data.UserID,
          `${data.CusID} f.a ${data.AccNo} .sKqug Kh whùu`,
          sCusName,
          sCusAddress,
          LoanInterestReceived.toFixed(2),
          parseFloat(PenaltyInterestAmount).toFixed(2),
          fundAmount.toFixed(2),
          "N",
          NewDueInteCF.toFixed(2),
          parseFloat(data.Debit.replace(/,/g, "").trim()).toFixed(2),
          parseFloat(data.Debit.replace(/,/g, "").trim()).toFixed(2),
          new Date().toLocaleTimeString("en-US", {
            hour: "2-digit",
            minute: "2-digit",
            second: "2-digit",
            hour12: true,
          }),
          `${data.AccNo} LOAN CR. ${LoanCapitalPortion} REF: ${data.MobileNote}`,
          data.BankCode,
          "0.00",
        ]
      );

      if (LoanCapitalPortion > 0) {
        await connection.query(
          `INSERT INTO ledgertransactions(TransactionID, LedgerID, AccountNumber, CustomerID, CustomerName, CustomerAddress, TransactionDate, DebitAmount, CreditAmount, AccountBalance, ChequeNo, ChequeDate, Description, TransactionType, TransactionLog, TransactionNo, PageNo, UserID, sDescription, sCustomerName, sCustomerAddress, CashTenderd, CashBalance, TransactionTime, prntDescription, CashOrBankLedgerID, CashOrCurrentAccount, TransactionRelatedBranch) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)`,
          [
            newTransactionNumber,
            LedgerID,
            data.AccNo,
            data.CusID,
            eCusName,
            eCusAddress,
            new Date().toISOString().split("T")[0],
            "0.00",
            LoanCapitalPortion,
            parseFloat(AccountBalance) - LoanCapitalPortion,
            null,
            null,
            `Mobile Loan recovery capital for AC: ${data.AccNo} From ${data.CusID}`,
            TransactionType,
            "LOAN BATCH DEPOSIT",
            null,
            null,
            data.UserID,
            `${data.CusID} f.a ${data.AccNo} Kh jdßl whùu - CIA;% /ialsrSï`,
            sCusName,
            sCusAddress,
            parseFloat(data.Debit.replace(/,/g, "").trim()).toFixed(2),
            parseFloat(data.Debit.replace(/,/g, "").trim()).toFixed(2),
            new Date().toLocaleTimeString("en-US", {
              hour: "2-digit",
              minute: "2-digit",
              second: "2-digit",
              hour12: true,
            }),
            `${data.AccNo} LOAN CR. ${LoanCapitalPortion} REF: ${data.MobileNote}`,
            fo_cashbook_id,
            "CA",
            data.BankCode,
          ]
        );

        // NOTE: Get ledgerdetails
        const [results7] = await connection.query(
          `SELECT PassdueAmount FROM ledgerdetails WHERE AccountNumber = ?`,
          [data.AccNo]
        );
        PastDueAmountBeforeRecovery = results7[0].PassdueAmount; // COMMENT: Destructure pass due amount

        if (parseFloat(LoanInstallment) > 0) {
          let CalculatingPastDueAmount =
            parseFloat(PastDueAmountBeforeRecovery) -
            parseFloat(LoanCapitalPortion);
          let NewPastDueAmount = "0.00";
          let NewOverDueAmount = "0.00";
          let NewPastDueInstallment = "0.00";
          let NewOverdueInstallment = "0.00";
          let DailyLoanInstallment = (parseFloat(LoanInstallment) / 365) * 12;
          let PastDueDays = 0;

          if (CalculatingPastDueAmount < 0) {
            NewOverDueAmount = (CalculatingPastDueAmount * -1).toFixed(2);
            NewPastDueAmount = "0.00";
            PastDueDays = 0;
            NewPastDueInstallment = "0.00";
            NewOverdueInstallment = (
              CalculatingPastDueAmount / parseFloat(LoanInstallment)
            ).toFixed(2);
          } else {
            NewOverDueAmount = "0.00";
            NewPastDueAmount = CalculatingPastDueAmount.toFixed(2);
            PastDueDays = parseInt(
              Math.floor(CalculatingPastDueAmount / DailyLoanInstallment)
            );
            NewPastDueInstallment = (
              CalculatingPastDueAmount / parseFloat(LoanInstallment)
            ).toFixed(2);
            NewOverdueInstallment = "0.00";
          }

          await connection.query(
            `UPDATE ledgerdetails SET PassdueInstallments = ?, PassdueAmount = ?, OverdueInstallment = ?, OverdueAmount = ?, PastDuedays = ? WHERE AccountNumber = ?`,
            [
              NewPastDueInstallment,
              NewPastDueAmount,
              NewOverdueInstallment,
              NewOverDueAmount,
              PastDueDays.toString(),
              data.AccNo,
            ]
          );
        } // END OF (LoanInstallment > 0)
      } // END OF (LoanCapitalPortion > 0)

      if (parseFloat(AccountBalance) - parseFloat(LoanCapitalPortion) === 0) {
        await connection.query(`CALL APP_REMOVE_FDHOLD(?)`, [data.AccNo]);
      }

      if (LoanInterestReceived > 0) {
        await connection.query(
          `INSERT INTO ledgertransactions(TransactionID, LedgerID, AccountNumber, CustomerID, CustomerName, CustomerAddress, TransactionDate, DebitAmount, CreditAmount, AccountBalance, ChequeNo, ChequeDate, Description, TransactionType, TransactionLog, TransactionNo, PageNo, UserID, sDescription, sCustomerName, sCustomerAddress, CashTenderd, CashBalance, TransactionTime, prntDescription, CashOrBankLedgerID, CashOrCurrentAccount, TransactionRelatedBranch) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)`,
          [
            newTransactionNumber,
            InterestAccount,
            null,
            data.CusID,
            eCusName,
            eCusAddress,
            new Date().toISOString().split("T")[0],
            "0.00",
            LoanInterestReceived.toFixed(2),
            null,
            null,
            null,
            `Loan recovery interest for AC: ${data.AccNo} From ${data.CusID}`,
            TransactionType,
            "LOAN BATCH DEPOSIT",
            null,
            null,
            data.UserID,
            `${data.CusID} f.a ${data.AccNo} Kh fmd<S whùu`,
            sCusName,
            sCusAddress,
            parseFloat(data.Debit.replace(/,/g, "").trim()).toFixed(2),
            parseFloat(data.Debit.replace(/,/g, "").trim()).toFixed(2),
            new Date().toLocaleTimeString("en-US", {
              hour: "2-digit",
              minute: "2-digit",
              second: "2-digit",
              hour12: true,
            }),
            `${data.AccNo} CR LOAN INTE. MOB`,
            fo_cashbook_id,
            "CA",
            data.BankCode,
          ]
        );
      }

      if (penaltyInterestAmount > 0) {
        await connection.query(
          `INSERT INTO ledgertransactions(TransactionID, LedgerID, AccountNumber, CustomerID, CustomerName, CustomerAddress, TransactionDate, DebitAmount, CreditAmount, AccountBalance, ChequeNo, ChequeDate, Description, TransactionType, TransactionLog, TransactionNo, PageNo, UserID, sDescription, sCustomerName, sCustomerAddress, CashTenderd, CashBalance, TransactionTime, prntDescription, CashOrBankLedgerID, CashOrCurrentAccount, TransactionRelatedBranch) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)`,
          [
            newTransactionNumber,
            PenaltyOrReservationAccount,
            null,
            data.CusID,
            eCusName,
            eCusAddress,
            new Date().toISOString().split("T")[0],
            "0.00",
            penaltyInterestAmount.toFixed(2),
            null,
            null,
            null,
            `Loan recovery penalty for AC: ${data.AccNo} From ${data.CusID}`,
            TransactionType,
            "LOAN BATCH DEPOSIT",
            null,
            null,
            data.UserID,
            `${data.CusID} f.a ${data.AccNo} Kh fmd<S whùu`,
            sCusName,
            sCusAddress,
            parseFloat(data.Debit.replace(/,/g, "").trim()).toFixed(2),
            parseFloat(data.Debit.replace(/,/g, "").trim()).toFixed(2),
            new Date().toLocaleTimeString("en-US", {
              hour: "2-digit",
              minute: "2-digit",
              second: "2-digit",
              hour12: true,
            }),
            `${data.AccNo} CR LOAN PENALTY. MOB`,
            fo_cashbook_id,
            "CA",
            data.BankCode,
          ]
        );
      }

      if (fundAmount > 0) {
        await connection.query(
          `INSERT INTO ledgertransactions(TransactionID, LedgerID, AccountNumber, CustomerID, CustomerName, CustomerAddress, TransactionDate, DebitAmount, CreditAmount, AccountBalance, ChequeNo, ChequeDate, Description, TransactionType, TransactionLog, TransactionNo, PageNo, UserID, sDescription, sCustomerName, sCustomerAddress, CashTenderd, CashBalance, TransactionTime, prntDescription, CashOrBankLedgerID, CashOrCurrentAccount, TransactionRelatedBranch) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)`,
          [
            newTransactionNumber,
            FundAccount,
            null,
            data.CusID,
            eCusName,
            eCusAddress,
            new Date().toISOString().split("T")[0],
            "0.00",
            fundAmount.toFixed(2),
            null,
            null,
            null,
            `Loan recovery fund for AC: ${data.AccNo} From ${data.CusID}`,
            TransactionType,
            "LOAN BATCH DEPOSIT",
            null,
            null,
            data.UserID,
            `${data.CusID} f.a ${data.AccNo}  úúO whùu`,
            sCusName,
            sCusAddress,
            parseFloat(data.Debit.replace(/,/g, "").trim()).toFixed(2),
            parseFloat(data.Debit.replace(/,/g, "").trim()).toFixed(2),
            new Date().toLocaleTimeString("en-US", {
              hour: "2-digit",
              minute: "2-digit",
              second: "2-digit",
              hour12: true,
            }),
            `${data.AccNo} CR LOAN FUND. MOB`,
            fo_cashbook_id,
            "CA",
            data.BankCode,
          ]
        );
      }

      // NOTE: Update last_ReceiptNo
      await connection.query(
        `UPDATE systemusers SET last_ReceiptNo = ? WHERE UserID = ?`,
        [newTransactionNumber, data.UserID]
      );

      // NOTE: SMS and Print Receipt
      const [results8] = await connection.query(
        `select SendSMSForEveryCustomer,PrintReceiptForEveryCustomer from instituteinformation where InstituteID=?`,
        [data.BankCode]
      );
      // COMMENT: Destructure SMS and Print Receipt RULES
      if (results8.length > 0) {
        const {
          SendSMSForEveryCustomer: sendSMS,
          PrintReceiptForEveryCustomer: printReceipt,
        } = results8[0];
        SMSendForAllCustomersByBankRule = sendSMS.toString();
        PrintReceiptForEveryCustomer = printReceipt.toString();
      }

      // NOTE: Generate SMS's
      const [results9] = await connection.query(
        `SELECT smsLang,PersonnalMobileNo,smsRegistered FROM customerinformation WHERE CustomerID=?`,
        [data.CusID]
      );
      // COMMENT: Destructure SMS details
      const {
        smsLang: lang,
        PersonnalMobileNo: mobileNo,
        smsRegistered: registered,
      } = results9[0];

      // COMMENT: Generate SMS
      if (
        Boolean(registered) ||
        parseInt(SMSendForAllCustomersByBankRule, 10) === 1
      ) {
        if (lang.toLowerCase() === "en") {
          sms = `Dear customer, Loan Recovery CR was performed on your account no. ${
            data.AccNo
          } for Rs. ${parseFloat(cleanAmount).toLocaleString("en-IN", {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2,
          })} Available Rs. ${(
            parseFloat(AccountBalance) - parseFloat(cleanAmount)
          ).toLocaleString("en-IN", {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2,
          })} - ${new Date().toISOString().replace("T", " ").slice(0, 19)}`;
        } else if (lang.toLowerCase() === "si") {
          sms = `Hithawath paribogikaya, Obage ${
            data.AccNo
          } naya ginumata Rs. ${parseFloat(cleanAmount).toLocaleString(
            "en-IN",
            {
              minimumFractionDigits: 2,
              maximumFractionDigits: 2,
            }
          )} aya wiya. ginume sheshaya Rs. ${(
            parseFloat(AccountBalance) - parseFloat(cleanAmount)
          ).toLocaleString("en-IN", {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2,
          })} - ${new Date().toISOString().replace("T", " ").slice(0, 19)}`;
        }

        // COMMENT: Insert SMS

        await connection.query(`CALL APP_INSERT_SMS_Q(?, ?, ?, ?)`, [
          data.CusID,
          mobileNo,
          new Date().toISOString().replace("T", " ").substring(0, 19),
          sms,
        ]);
      }

      // NOTE: Comment the transaction
      await connection.commit();
      return {
        id: data.Id,
        transactionNo: newTransactionNumber,
        printReceipt: PrintReceiptForEveryCustomer,
      };
    } catch (error) {
      if (connection) {
        await connection.rollback();
      }
      throw error;
    } finally {
      if (connection) {
        connection.release();
      }
    }
  },
};
