const {
  getLoanAccounts,
  getSavingAccounts,
  addTransaction,
  addRealTimeLoan,
  addRealTimeSaving,
} = require("./transaction.controller");

const router = require("express").Router();
const { checkToken } = require("../../auth/token_validation");

router.get("/savings", checkToken, getSavingAccounts);
router.get("/loans", checkToken, getLoanAccounts);
router.post("/addTransaction", checkToken, addTransaction);
router.post("/addRealTimeLoan", checkToken, addRealTimeLoan);
router.post("/addRealTimeSaving", checkToken, addRealTimeSaving);

module.exports = router;
