const {
  getLoanAccounts,
  getSavingAccounts,
  addTransaction,
  addRealTimeSaving,
  addRealTimeLoan,
} = require("./transaction.service");
module.exports = {
  // Get Savings
  getSavingAccounts: async (req, res) => {
    try {
      const results = await getSavingAccounts();
      return res.status(200).json({
        success: 1,
        data: results[0],
      });
    } catch (err) {
      return res.status(500).json({
        success: 0,
        message: "Internal server error",
        error: err,
      });
    }
  },

  // Get Loans
  getLoanAccounts: async (req, res) => {
    try {
      const results = await getLoanAccounts();
      return res.status(200).json({
        success: 1,
        data: results[0],
      });
    } catch (err) {
      return res.status(500).json({
        success: 0,
        message: "Internal server error",
        error: err,
      });
    }
  },

  // Add Transaction
  addTransaction: async (req, res) => {
    const body = req.body;

    if (
      !body.Id ||
      !body.AccNo ||
      !body.CusID ||
      !body.TraDate ||
      !body.TraTime ||
      !body.Debit ||
      !body.Credit ||
      !body.UserID ||
      !body.DeviceID ||
      !body.Latitude ||
      !body.Longitude
    ) {
      return res.status(400).json({
        success: 0,
        message: "Some fields are missing",
      });
    }

    try {
      const results = await addTransaction(body);
      if (results["affectedRows"] === 0) {
        return res.status(400).json({
          success: 0,
          message: "Failed to add transaction, try again later.",
        });
      }
      return res.status(200).json({
        success: 1,
        message: "Transaction added successfully",
      });
    } catch (err) {
      return res.status(500).json({
        success: 0,
        message: "Internal Server error, try again later.",
        error: err.message,
      });
    }
  },

  addRealTimeSaving: async (req, res) => {
    const body = req.body;

    if (
      !body.Id ||
      !body.AccNo ||
      !body.CusID ||
      !body.TraDate ||
      !body.TraTime ||
      !body.Debit ||
      !body.Credit ||
      !body.UserID ||
      !body.DeviceID ||
      !body.Latitude ||
      !body.Longitude ||
      !body.BankCode
    ) {
      return res.status(400).json({
        success: 0,
        message: "Some fields are missing",
      });
    }

    try {
      const results = await addRealTimeSaving(body);
      return res.status(200).json({
        success: 1,
        message: "Transaction completed successfully",
        data: results,
      });
    } catch (err) {
      return res.status(500).json({
        success: 0,
        message: "Internal Server error, try again later.",
        error: "Rolling back transaction, ERROR: " + err.message,
      });
    }
  },

  addRealTimeLoan: async (req, res) => {
    const body = req.body;

    if (
      !body.Id ||
      !body.AccNo ||
      !body.CusID ||
      !body.TraDate ||
      !body.TraTime ||
      !body.Debit ||
      !body.Credit ||
      !body.UserID ||
      !body.DeviceID ||
      !body.Latitude ||
      !body.Longitude
    ) {
      return res.status(400).json({
        success: 0,
        message: "Some fields are missing",
      });
    }
    try {
      const results = await addRealTimeLoan(body);
      return res.status(200).json({
        success: 1,
        message: "Transaction completed successfully",
        data: results,
      });
    } catch (err) {
      return res.status(500).json({
        success: 0,
        message: "Internal Server error, try again later.",
        error: "Rolling back transaction, ERROR: " + err.message,
      });
    }
  },
};
