const { genSaltSync, hashSync, compareSync } = require("bcrypt");

module.exports = {
  encrypt: (req, res) => {
    const body = req.body;

    if (!body.password) {
      return res.status(400).json({
        success: 0,
        message: "Password is missing",
      });
    }

    try {
      const salt = genSaltSync(10);
      body.password = hashSync(body.password, salt);

      return res.json({
        success: 1,
        message: "Password encrypted successfully",
        results: body,
      });
    } catch (err) {
      return res.status(500).json({
        success: 0,
        message: "Internal server error",
        error: err,
      });
    }
  },

  decrypt: async (req, res) => {
    const body = req.body;

    if (!body.password || !body.hash) {
      return res.status(400).json({
        success: 0,
        message: "Password or hash is missing",
      });
    }

    try {
      const result = compareSync(body.password, body.hash);

      return res.json({
        success: 1,
        message: "Password comparison result",
        results: result,
      });
    } catch (err) {
      return res.status(500).json({
        success: 0,
        message: "Internal server error",
        error: err,
      });
    }
  },
};
