const pool = require("../../config/database");

module.exports = {
  addLocationService: async (data) => {
    try {
      const [results] = await pool.query(
        `CALL ADD_DEVICE_LOCATION(?, ?, ?, ?)`,
        [data.deviceID, data.latitude, data.longitude, data.timestamp]
      );
      return results;
    } catch (error) {
      throw error;
    }
  },
  
  checkDeviceService: async (data) => {
    try {
      const [results] = await pool.query(
        `CALL IS_MOBILE_DEVICE_REGISTERED(?, ?)`,
        [data.bankID, data.deviceID]
      );
      return results;
    } catch (error) {
      throw error;
    }
  },
};
