const { addLocationService, checkDeviceService } = require("./device.service");
const { sign, verify } = require("jsonwebtoken");

module.exports = {
  addLocation: async (req, res) => {
    const body = req.body;
    if (
      !body.deviceID ||
      !body.latitude ||
      !body.longitude ||
      !body.timestamp
    ) {
      return res.status(400).json({
        success: 0,
        message: "Some Fields are missing",
      });
    }

    try {
      const results = await addLocationService(body);
      if (results.affectedRows === 0) {
        return res.status(200).json({
          success: 0,
          message: "Location not added",
          result: results,
        });
      }
      return res.status(200).json({
        success: 1,
        message: "Updated Successfully",
        affectedRows: results.affectedRows,
      });
    } catch (err) {
      console.log(err);
      return res.status(500).json({
        success: 0,
        message: "Internal server error",
      });
    }
  },

  checkDevice: async (req, res) => {
    const body = req.body;
    if (!body.deviceID || !body.bankID) {
      return res.status(400).json({
        success: 0,
        message: "Some Fields are missing",
      });
    }

    try {
      const results = await checkDeviceService(body);
      const status = results[0][0].Status;
      if (status == "Verified") {
        return res.status(200).json({
          success: 1,
          status: status,
        });
      } else {
        return res.status(404).json({
          success: 0,
          status: status,
        });
      }
    } catch (err) {
      console.log(err);
      return res.status(500).json({
        success: 0,
        message: "Internal server error",
      });
    }
  },
};
