const { getCustomers } = require("./customers.service");
module.exports = {
  getCustomers: async (req, res) => {
    try {
        const results = await getCustomers();
        return res.json({
            status: 1,
            data: results[0],
        });
    } catch (err) {
      console.log(err);
      return res.status(500).json({
        success: 0,
        message: "Internal server error",
        error: err,
      });
    }
  },
};
